/**
 * wtnGfeed
 *
 * Google AJAX Feed API (Open Feeds Download)
 * for 楽天すぺしゃる
 *
 * @author    Tenderfeel <tenderfeel@gmail.com>
 * @copyright Copyright (c) 2010 Tenderfeel.(http://webtecnote.com)
 * @license   The MIT License
 */

var wtnGfeed = function(){

	var $ = {
		
		container:null,
		
		id:'',
		
		url : 'http://api.shop.plaza.rakuten.co.jp/{shopid}/rss/',
		
		_default:{
			"element":"gfeed",
			"max":3,
			"text":100,
			"feedBlock":"dl",
			"lineBlock":"",
			"titleBlock":"dt",
			"titleBox":"",
			"dateBox":"span",
			"contentBlock":"dd",
			"dateformat":"%Y/%M/%D"
		},
		
		option:{},
		
		load:function(){
			if($.id!==""){$.url = $.url.replace('{shopid}',$.id);}
			
			var feed = new google.feeds.Feed($.url);
			
			feed.load(function(result) {
				$.render(result);
			});
		},
		
		render:function(result){
			var option = marge($._default,$.option);
			$.container = document.getElementById(option.element);
			$.container.innerHTML ="";
			
			var feedBlock = new Element(option.feedBlock);
			var viewMax = (result.feed.entries.length<option.max)?result.feed.entries.length:option.max;
			
			for (var i = 0; i < viewMax ; i++) {
				if(i >= result.feed.entries.length) return;
				
				var entry = result.feed.entries[i];
				var date = dateformat(entry["publishedDate"],option.dateformat);
				var title = '<a href="'+entry["link"]+'" target="_blank">'+entry["title"]+'</a>';
				var str = entry["content"].replace(/\s/,"");
				
				if(option.text!="all"||option.text==0){
					str = str.replace(/<\/?[^>]+>/gi, "");
					str = str.substring(0, option.text);
				}
				
				if(isString(option.lineBlock)){
					var lineBlock = new Element(option.lineBlock);
				}
				
				if(isString(option.titleBlock)){
					var titleBlock = new Element(option.titleBlock, {'class':'title'});
				}
				
				titleParent = lineBlock || titleBlock;
				
				if(isString(option.dateBox)){
					var dateBox = new Element(option.dateBox, {'class':'date','html':date});
					titleParent.appendChild(dateBox);
					
				}else if(option.dateBox===""){
					titleParent.innerHTML += date;
				}
				
				if(isString(option.titleBox)){
					var titleBox = new Element(option.titleBox, {'class':'titleBody','html':title});
					titleParent.appendChild(titleBox);
				}else if(option.titleBox===""){
					titleParent.innerHTML += title;
				}
				
				feedBlock.appendChild(titleParent);
				
				contentParent = lineBlock || feedBlock;
				
				if(isString(option.contentBlock)){
					var contentBox = new Element(option.contentBlock, {'class':'snippet','html':str});
					contentParent.appendChild(contentBox);
				}else if(option.contentBlock ===""){
					contentParent.innerHTML += str;
				}
			
				$.container.appendChild(feedBlock);
			}
		},
		
		shopID:function(str){
			if(typeof str === 'string') $.id = str;
		},
		
		set:function(option){
			if(typeof option === 'object') marge($.option, option);
			else if(typeof option === 'string') $.url = option;
		}
		
	};
	
	var marge = function(obj1, obj2){
		if(typeof obj2 !== 'object') return obj1;
		
		for(var i  in obj2){
			obj1[i] = obj2[i];
		}
		return obj1;
	};
		
	var isString = function(str){
		return ((str!=="") && (typeof str=="string"));
	};
	
	var Element = function(tag, option){
		var obj = document.createElement(tag);
		
		if(typeof option == 'object'){
			if(option['class']) obj.className = option['class'];
			if(option.html) obj.innerHTML = option.html;
		}
		
		return obj;
	};
	
	var dateformat = function(date, format){
		dd = new Date(date);
		yy = dd.getYear();
		mm = dd.getMonth() + 1;
		d = dd.getDate();
		hh = dd.getHours();
		mi = dd.getMinutes();
		mm2 = mm;
		d2 = d;
		
		if (yy < 2000) { yy += 1900; }
		if (mm < 10) { mm2 = "0" + mm; }
		if (d < 10) { d2 = "0" + d; }
		
		y2 = yy+''.substring(2,4);
		
		var out = format.replace('%Y', yy);
		out = out.replace('%M', mm);
		out = out.replace('%m', mm2);
		out = out.replace('%D', d);
		out = out.replace('%d', d2);
		out = out.replace('%h', hh);
		out = out.replace('%i', mi);
		
		return out;
	};
	
	return $;
};

var gfeed = new wtnGfeed();