/**
	Google Maps API V3 [Root Map Template]
	@author Tenderfeel(tenderfeel@gmail.com)
	@website http://webtecnote.com/
	@version 1.0
	@since 2010-09-10
*/
/*-------- Config ----------*/
var gmConfig = {
	'lat':35.681382,
	'lng':139.766084,
	'zoom':17, //zoom level(0-19)
	'lang':'ja', //language
	'ID':"gmap", //DIV Element ID
	'sensor':'false', //Use Sensor? (yes:true, no:false)
	"streetView": true, //ストリートビューの使用
	"directions":true,//ルート案内の使用
	'marker':{
		'title':'東京駅'
	},
	'iw':{
		'content':"<strong>東京駅</strong>" //InfoWindow content
	}
}
/*---------------------------*/
	
google.load("maps", "3",{"callback" : mapsLoaded, "language" : gmConfig.lang, "other_params": 'sensor='+gmConfig.sensor});

var marker,map,latlng,infowindow;
var direction_html={};

function mapsLoaded() {
	latlng = new google.maps.LatLng(gmConfig.lat, gmConfig.lng);
	var myOptions = {
		zoom: gmConfig.zoom,
		center: latlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		 streetViewControl:gmConfig.streetView
	};
	
	map = new google.maps.Map(document.getElementById(gmConfig.ID), myOptions);

	marker = new google.maps.Marker({
		position: latlng,
		map: map,
		title: gmConfig.marker.title
	});
	
	
	if(gmConfig.directions){
		setDirections();
		map_direction();
	}
	
	google.maps.event.addListener(marker, 'click', function() {
		if(infowindow) infowindow.close();									
		infowindow = new google.maps.InfoWindow({
			content: gmConfig.iw.content +((gmConfig.directions)?direction_html.normal:"")
		});
		infowindow.open(map,marker);
	});
}

/*///////////////////// GDirections /////////////////////////////*/
function map_direction(){

	direction_html["to"] = '<div style="margin-top:0.5em">ルート案内: <em>ここへ到着<\/em> - <a href="javascript:fromhere()">ここから出発<\/a>' +
	   '<form action="javascript:getDirections()" style="margin:0.5em 0">' +
	   '<label for="startloc">出発地:</label><input type="text" name="startloc" id="startloc" value="" />' +
	   '<input value="検索" TYPE="SUBMIT" /><br />' +
	   '<label><input type="radio" name="mode" id="walk" />徒歩</label> <label><input type="radio" name="mode" id="bicycling" />自転車</label> <label><input type="radio" name="mode" id="drive" checked="checked" />車</label><br /><label><input type="checkbox" name="highways" id="highways" />高速道路を避ける</label> <label><input type="checkbox" id="tollroads" />有料道路を避ける</label>' +
	   '<input type="hidden" id="endloc" value="'+ latlng.lat() + ',' + latlng.lng() + 
	   '"/></div>';
	
	direction_html["from"] = '<div style="margin-top:0.5em">ルート案内: <a href="javascript:tohere()">ここへ到着<\/a> - <em>ここから出発<\/em>' +
	   '<form action="javascript:getDirections()" style="margin:0.5em 0">' +
	   '<label for="endloc">目的地:</label><input type="text" name="endloc" id="endloc" value="" />' +
	   '<input value="検索" TYPE="SUBMIT" /><br />' +
	   '<label><input type="radio" name="mode" id="walk" />徒歩</label> <label><input type="radio" name="mode" id="bicycling" />自転車</label> <label><input type="radio" name="mode" id="drive" checked="checked" />車</label><br /><label><input type="checkbox" name="highways" id="highways" />高速道路を避ける</label> <label><input type="checkbox" id="tollroads" />有料道路を避ける</label>' +
	   '<input type="hidden" id="startloc" value="'+latlng.lat() + ',' + latlng.lng() +'"/></div>';
	
	direction_html["normal"] = '<div style="margin-top:0.5em">ルート案内: <a href="javascript:tohere()">ここへ到着<\/a> - <a href="javascript:fromhere()">ここから出発<\/a></div>';
}

// functions that open the directions forms
function tohere() {
	if(infowindow) infowindow.close();
	infowindow = new google.maps.InfoWindow({
		content: gmConfig.iw.content + direction_html.to
	});
	infowindow.open(map,marker);
}
function fromhere() {
	if(infowindow) infowindow.close();
	infowindow = new google.maps.InfoWindow({
		content: gmConfig.iw.content + direction_html.from
	});
	infowindow.open(map,marker);
}

// Directions
function setDirections(){
	var directionDiv = document.getElementById("directions");
	//close button
	closeDirection = document.createElement("div");
	closeDirection.innerHTML = '<span style="background-color:#fff;border-style:solid;border-width:1px;border-color:white #B0B0B0 #B0B0B0 white;display:block;padding:0;margin:0;text-align:center;width:1.3em">×</span>';
	closeDirection.id="closeDirection";
	closeDirection.style.border="solid 1px #000";
	closeDirection.style.display ="none";
	closeDirection.style.cursor = "pointer";
	directionDiv.appendChild(closeDirection);
	
	closeDirection.onclick =function(){
		this.style.display = (this.style.display == "none")? "block":"none";
		
		directionsDisplay.setMap(null);
		directionsDisplay.setPanel(null);
		directionsDisplay = new google.maps.DirectionsRenderer();
		directionsDisplay.setMap(map);
		directionsDisplay.setPanel(directionDiv); 
		if (infowindow) infowindow.close();
		map.setCenter(latlng);
	};
	
	directionsService = new google.maps.DirectionsService();
	directionsDisplay = new google.maps.DirectionsRenderer();
	directionsDisplay.setMap(map);
	directionsDisplay.setPanel(directionDiv);
}

function getDirections() {
	var opts = {};
	var mode = google.maps.DirectionsTravelMode.DRIVING;
	
	opts.locale = "ja";
	
	//徒歩
	if (document.getElementById("walk").checked) {
	   mode = google.maps.DirectionsTravelMode.WALKING;
	}
	//車
	if (document.getElementById("drive").checked) {
	   mode = google.maps.DirectionsTravelMode.DRIVING;
	}
	
	//自転車
	if (document.getElementById("bicycling").checked) {
	   mode = google.maps.DirectionsTravelMode.BICYCLING;
	}
	
	//高速
	if (document.getElementById("highways").checked) {
	   directionsService.avoidHighways = true;
	}
	
	//有料道路
	if (document.getElementById("tollroads").checked) {
	   directionsService.avoidTolls = true;
	}
	
	// ==== set the start and end locations ====
	var startloc = document.getElementById("startloc").value
	var endloc = document.getElementById("endloc").value
	
	var request = {
        origin:startloc, 
        destination:endloc,
        travelMode: mode
    };
	
    directionsService.route(request, function(response, status) {
      if (status == google.maps.DirectionsStatus.OK) {
		closeDirection.style.display ="block";
        directionsDisplay.setDirections(response);
      }
    });
}