/*
---
description:    DataTree

version: 1.0

authors:
  - Tenderfeel (http://webtecnote.com)

license:
  - MIT-style license

requires:
  core/1.2.1 upper
...
*/
(function($) {
			  
	this.dataTree = new Class({
		
		Implements: [Options,Events],
	
		options: {
			target: 'tree',//ID
			root:'root-item',//ID
			data:'root-data',//ID
			activeItemClass:'active',//Class
			rootTextCentering:true,//auto centering(vertical)
			onOpen:$empty,
			onClose:$empty,
			onActive:$empty,
			onInactive:$empty
		},
		
		initialize: function(options) {
			
			this.setOptions(options);
			$this = this;
			
			this.element = $(this.options.target);
			this.dataElement = $(this.options.data);
			this.rootItem = $(this.options.root);
			this.lists = this.element.getElements('.list');
			
			this.lists.each(function(li){
				var dt = li.getFirst('.item');
				var dd = dt.getNext();
				
				var gadjet = new Element('span',{'class':'gadjet',
										   'events':{
												'click':function(e){
													e.stop();
													var dl = this.getParent('.list');
													dl.toggleClass('close');
													
													if(dl.open !== true){
														dl.open = true;
														$this.fireEvent('close',dl);
														dd.style.display='none';
														$this.setRootItem();
													}else{
														dl.open = false;
														$this.fireEvent('open',dl);
														dd.style.display='block';
														$this.setRootItem();
													}
												}
											   }});
				
				gadjet.inject(dt,'top');
				
				if(dd.getChildren().length==1){
					li.addClass('single');
				}else{
					dd.getLast().addClass('last');
				}
			});
			
			this.element.getElements('.name').each(function(a,i){
				a.addEvent('click',function(e){
					e.stop();
					a.toggleClass($this.options.activeItemClass);
					
					if(a.active !== true){
						a.active = true;
						$this.fireEvent('active', [a.getParent(), a]);
					}else{
						a.active = false;
						$this.fireEvent('inactive', [a.getParent(), a]);
					}
				});
			});
			
			this.setRootItem();
			
		},
		
		setRootItem: function() {
			
			var first = this.dataElement.getFirst().getPosition(this.element).y;
			var last = this.dataElement.getLast().getPosition(this.element).y;
			
			this.rootItem.setStyle('height',(first+last));
			
			var name = this.rootItem.getElement('.name');
			var text = name.get('text').replace(/(<\/?([a-z][a-z0-9]*)\b[^>]*>)|([\r\s\n]*)/gi,'');
			var wrap = this.rootItem.getElement('.text')||new Element('div',{'class':'text'});
			var stext = this.textSlice(text);
			
			name.inject(wrap);
			
			if(this.options.rootTextCentering){
				var mt = (text.length*15)/2;
				
				name.set('html', stext);
				wrap.addClass('center');
				wrap.setStyles({
							   'position':'absolute',
							   'top':(first+last+20)/2 - mt,
							   'left':0
							  	});
				
			}
			
			wrap.inject(this.rootItem);
		},
		
		textSlice:function(txt){
		    var max = txt.length;
		    var array = [];
		    for (i = 0; i <max ; i++) {
		        var str = txt.charAt(i);
		        array.push(str);
		    }
		    return '<span>'+array.join("</span><span>");
		}
		
	});
	})(document.id);