/**
	Google Maps API V3 [Simple Map Template]
	@author Tenderfeel(tenderfeel@gmail.com)
	@website http://webtecnote.com/
	@version 1.0
	@since 2010-06-14
*/
/*-------- Config ----------*/
var gmConfig = {
	'lat':35.681382,
	'lng':139.766084,
	'zoom':8, //zoom level(0-19)
	'lang':'ja', //language
	'ID':"gmap", //DIV Element ID
	'sensor':'false', //Use Sensor? (yes:true, no:false)
	'marker':{
		'title':'Hellow World!'
	},
	'iw':{
		'content':"<strong>Hellow World!!</strong>" //InfoWindow content
	}
}
/*---------------------------*/
	
google.load("maps", "3",{"callback" : mapsLoaded, "language" : gmConfig.lang, "other_params": 'sensor='+gmConfig.sensor});

function mapsLoaded() {
	var latlng = new google.maps.LatLng(gmConfig.lat, gmConfig.lng);
	var myOptions = {
		zoom: gmConfig.zoom,
		center: latlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	var map = new google.maps.Map(document.getElementById(gmConfig.ID), myOptions);

	var marker = new google.maps.Marker({
		position: latlng,
		map: map,
		title: gmConfig.marker.title
	});
	google.maps.event.addListener(marker, 'click', function() {
		new google.maps.InfoWindow({
			content: gmConfig.iw.content
		}).open(map,marker);
	});
}