/* 
 * WTN*Google Maps Template (V3 API)
 * @author Tenderfeel(tenderfeel@gmail.com)
 * @ver 1.0
 * @HOME http://webtecnote.com/
 * @link /googlemap/869/
 * @Need:Google Ajax API Loader
 * 
 * ---MIT License--------------------------------------------
 * Copyright (c) 2010 Tenderfeel all rights reserved.
 * --------------------------------------------------------*/
 
var gmConfig = {
	"lat":35.681382,  //GLat
	"lng":139.766084, //GLng
	"divID":"gmap",    //地図を表示する要素のID
	"zoom":12,        //拡大率,
	"mapType":1,       //初期表示するマップタイプ（1:デフォルト,2:航空写真,3:地図＋写真,4:地形） 
	"navigationControl":true,// ナビゲーションレベルコントローラ（true/"SMALL"/"ZOOM_PAN"）
	"mapTypeControl":true, //地図タイプコントローラ (true/"DROPDOWN"）
	"scaleControl":false, //スケールの表示
	"DClickZoom":false, //ダブルクリックでのズーム操作(true:有効, false:無効）
	"scrollwheel":true, //ホイールでのズーム操作(true:有効, false:無効）
	"sensor":false, //センサーの使用
	"lang":"ja", //地図の言語
	"markerAdd":true,  //マーカーの表示
	"markerTitle":"", //マーカーのタイトル
	"infoWindowHtml":"<strong>Hello World!!</strong>" //ウィンドウのHTML
}

/* --------------------------------------------------------*/

google.load("maps", "3",{"callback" : mapsLoaded, "language" : gmConfig.lang, "other_params": 'sensor='+gmConfig.sensor});

function mapsLoaded() {
	
	var point = new google.maps.LatLng(gmConfig.lat, gmConfig.lng);
	var myOptions = {
	  zoom: gmConfig.zoom,
	  center: point,
	  
	  disableDefaultUI: true,
	  navigationControl: gmConfig.navigationControl,
	  mapTypeControl: gmConfig.mapTypeControl,
	  scaleControl:gmConfig.scaleControl,
	  disableDoubleClickZoom:(gmConfig.DClickZoom==true)?false:true,
	  scrollwheel:gmConfig.scrollwheel
	};
	
	//mapType switch
	switch(gmConfig.mapType){
		case 2:myOptions.mapTypeId = google.maps.MapTypeId.SATELLITE;break;
		case 3:myOptions.mapTypeId = google.maps.MapTypeId.HYBRID;break;
		case 4:myOptions.mapTypeId = google.maps.MapTypeId.TERRAIN;break;
		default:myOptions.mapTypeId = google.maps.MapTypeId.ROADMAP;break;
	}
	
	//mapTypeControl Option
	switch(myOptions.mapTypeControl){
		case "DROPDOWN":myOptions.mapTypeControlOptions = {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU};break;
		case "HORIZONTAL_BAR":myOptions.mapTypeControlOptions = {style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR};break;
	}
	
	//navControl Option
	switch(myOptions.navigationControl){
		case "SMALL":myOptions.navigationControlOptions={style:google.maps.NavigationControlStyle.SMALL};break;		
		case "ZOOM_PAN":myOptions.navigationControlOptions={style:google.maps.NavigationControlStyle.ZOOM_PAN};break;
		case "ANDROID":myOptions.navigationControlOptions={style:google.maps.NavigationControlStyle.ANDROID};break;
	}
	
	
	var map = new google.maps.Map(document.getElementById(gmConfig.divID), myOptions);
	
	if(gmConfig.markerAdd){
		var marker = new google.maps.Marker({
		  position: point, 
		  map: map, 
		  title:gmConfig.markerTitle
		});
		
		if(gmConfig.infoWindowHtml!=""){
			var infowindow = new google.maps.InfoWindow({
				content:gmConfig.infoWindowHtml
			});
			google.maps.event.addListener(marker, 'click', function() {
			  infowindow.open(map,marker);
			});
		}
	}
	
}
