/*-----------------------------------------------------
    Diagnosizm 診断テスト自動作成スクリプト
	
	@version    1.3.0
	@copyright Tenderfeel
	@author Tenderfeel(tenderfeel@gmail.com)
	@link http://tenderfeel.xsrv.jp/
	@page http://tenderfeel.xsrv.jp/mootools/775/
	@MIT Style License
	
------------------------------------------------------*/	

/*//////////////// O P T I O N S ///////////////////////

	url        :  JSONファイルまでのパス
	area       :  質問・結果表示場所のID
	button　　 :  ボタンID
	before     :  質問番号の前に入るHTML
	after      :  質問番号の後に入るHTML
	copyright  :  WTNへのリンク表示
	buttonText :  ボタン文字列
	restartText:  再診断ボタン文字列
	debug      :　デバッグモード
	
////////////////// Class and ID ////////////////////////
	
	tr.odd : 奇数行
	tr.even: 偶数行
	
	td.yes : YESのラジオボタンが入るTD
	td.no  : NOのラジオボタンが入るTD
	
	#error           : エラーメッセージのDIV要素
	.answer-zero     : 選択されていないエラー
	.not-all-checked : 全て選択されていないエラー
	
	#result    :  結果のDIV要素
	.result-XX :  結果に振られるクラス（XXはキー番号）
	
	.wtn-copyright : WTNへのリンク
	
///////////////////////////////////////////////////////*/

(function($,$$) { 

	this.Diagnosizm = new Class({
	
	Implements: [Options],

	options: {
		url:'question.json',
		area:'diagnosizm',
		button:'check',
		before:"Q",
		after:"：",
		copyright:true,
		buttonText:'診断',
		restartText:'もう一度診断する',
		debug:false
	},
	
	initialize: function(options){
		
		this.setOptions(options);
		$this=this;
		this.count = 0;
		this.answer = new Hash();
		this.tableFx =null;
		this.button = $(this.options.button);
		this.area = $(this.options.area);
		this.area.empty();
		
		 var request =new Request.JSON({
            method: 'get',
            url:this.options.url,
            onComplete: function(json) {
				$this.count = json.questions.length;
            	$this.create_question(json.questions);
				$this.create_answer(json.answers);
            }
        }).get();
		 
		 this.error = new Element("div",{"id":"error","morph":{duration:500}}).inject(this.options.area,"before");
		 this.error.morph({"line-height":0,"opacity":0});
		 
		this.button.addEvent("click",function(){
			if($this.button.get("text") == $this.options.buttonText) $this.result();
			else $this.restart();
		});
		
		if(this.options.copyright)
		new Element("p",{"class":"wtn-copyright","html":'<a href="http://tenderfeel.xsrv.jp/">Diagnosizm v1.0@WTN</a>'}).inject(this.button,"after");
	},
	
	create_question:function(obj){
		var table = new Element("table");
		var tbody = new Element("tbody");
		this.tableFx = new Fx.Morph(table);
		var count = 1;
		
		$each(obj,function(item,i){
			var cl = (i%2)? 'even':'odd';
			var tr = new Element("tr",{'class':cl}).grab(new Element("th",{"scope":"row","html":this.options.before+count+this.options.after+item.text}));
			
			new Element("td",{"class":"yes","html":'<label><input type="radio" value="'+item.yes+'" name="q'+i+'" />はい</label>'}).inject(tr);
			new Element("td",{"class":"no","html":'<label><input type="radio" value="'+item.no+'" name="q'+i+'" />いいえ</label>'}).inject(tr);
			tr.inject(tbody);
			
			count++;
		
		},this);
		
		tbody.inject(table);
		table.inject(this.area);
		
		table.getElements("input[type=radio]").addEvent('click',function(){
			if(this.error.hasClass("answer-zero")) this.error.removeClass("answer-zero").morph({"opacity":0,"line-height":0});
			
			var checked = table.getElements("input[type=radio]:checked");
			
			if(checked.length == obj.length) this.error.removeClass("not-all-checked").morph({"opacity":0,"line-height":0});
			
		}.bind(this));
	},
	
	create_answer:function(obj){
		$each(obj,function(item,i){
			this.answer.set(i,new Element("div",{"id":"result","class":"result-"+i,"html":item.html}).fade("hide"));
		
		},this);
		
	},
	
	result:function(){
		var radio = this.area.getElements("input[type=radio]:checked");
		var total = 0;
		
		if(radio.length == 0 && this.options.debug===false){
			$(document.body).scrollTo(0,this.error.getPosition().y);
			this.error.addClass("answer-zero").set("text","何も選択されていません。").morph({"opacity":1,"line-height":30});
		}else if(radio.length < this.count && this.options.debug===false){
			$(document.body).scrollTo(0,this.error.getPosition().y);
			this.error.addClass("not-all-checked").set("text","すべてチェックしてください").morph({"opacity":1,"line-height":30});
		}else{
			this.error.morph({"opacity":0,"line-height":0});
			
			this.tableFx.start({"opacity":0})
			.chain(function(){
				this.tableFx.element.setStyle("display","none");
				radio.each(function(r,i){
				total += r.get("value").toInt();
			});
				
				if(this.options.debug != false && $type(this.options.debug) == 'number'){total = this.options.debug;}
			
				this.get_result(total).inject(this.options.area).fade(1);
				$(document.body).scrollTo(0,this.area.getPosition().y);
				this.button.set("text",this.options.restartText);
				
			}.bind(this));
		}
	},
	
	get_result:function(total){
		var key = this.answer.filter(function(value, key){return key <= total;}).getKeys();
		return this.answer.get(key[0]).clone(true,true);
	},
	
	restart:function(){
		$("result").destroy();
		this.tableFx.start({"opacity":1});
		this.tableFx.element.setStyle("display","table");
		this.area.getElements("input").each(function(el){el.checked=false;});
		this.button.set("text",this.options.buttonText);
	}
});
})(document.id,document.search);