/**
 * SlidableViewer.js
 * @author Tenderfeel
 * @ver 1.0
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need:mootools 1.2
 *
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * ----------------------------------------------------------
 */
 
var SlidableViewer = new Class({
	
	Implements: [Options],
	
	options: {
		id:"picture",
		get:"img",
		mainClass:"top",
		duration:500,
		transition:'expo:out'
	},
	
	initialize: function(options) {
		this.setOptions(options);
		this.container = $(this.options.id);
		if(!this.container) return;
		this.pictures = this.container.getElements(this.options.get);
		this.container.store("current",0);
		
		$each(this.pictures,function(pict,i){
		
			if(!pict.hasClass(this.options.mainClass)) pict.style.display="none";
		
			pict.setStyles({"position":"absolute","top":0,"left":0,"z-index":0});
			pict.set("morph",{duration:this.options.duration,transition:this.options.transition,onComplete:function(){this.pictures[this.container.retrieve("old")].style.display="none";}.bind(this)});
		},this);
		
		var style = this.container.getStyles(["height","width","position"]);
		$extend(style,{"overflow":"hidden"});
		var wrap = new Element("div",{"styles":style});
		this.pictures.inject(wrap);
		wrap.inject(this.container);
		
		this.create_arrow();
		
	},
	
	create_arrow: function() {
		
		var self =this;
		
		var prev = new Element("a",{"href":"#","class":"prev","html":"Prev","title":"Prev",
						   "events":{
							   "click":function(e){
								   e.stop();
								   self.container.store("old",self.container.retrieve("current"));
								   self.pictures.setStyle("z-index",0);
								   var z = self.container.retrieve("current")-1;
								   var pic = self.pictures[z];
								   pic.morph({'left':[-pic.getStyle("width").toInt(),0],"z-index":1,"display":"block"});
								  if(z == 0) this.destroy();
								  if(z >= 0) next.inject(self.container);
								  self.container.store("current",z);
							   	}
							   }
						   });
	
		var next = new Element("a",{"href":"#","class":"next","html":"Next","title":"Next",
						   "events":{
							   "click":function(e){
								   e.stop();
								   self.container.store("old",self.container.retrieve("current"));
								   self.pictures.setStyle("z-index",0);
								   var z = self.container.retrieve("current")+1;
								   var pic = self.pictures[z];
								   pic.morph({'left':[pic.getStyle("width").toInt(),0],"z-index":1,"display":"block"});
								  if(z == self.pictures.length-1) this.destroy();
								  prev.inject(self.container);
								  self.container.store("current",z);
							   	}
							   }
						   });
		next.inject(this.container);
	}
	
});