/**
 * mooZoomGallery
 * @author Tenderfeel
 * @ver 1.0
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need: MooTools core 1.2.3 upper, More Assets
 * 
 * 
 * サムネイルを等寸へ拡大しながらセンタリングを行うギャラリープラグインです。
 * 正方形の画像をタイル上に並べた状態を想定してあります。
 * 
 * [XHTML SAMPLE]
 * 
 * <ul id="gallery">
 *  <li><div class="thumb"><img src="images2/01_thumb.jpg" alt="" width="150" height="150" /></div>
 *  <div class="info">Image:01</div></li>
 *  <li><div class="thumb"><img src="images2/02_thumb.jpg" alt="" width="150" height="150" /></div>
 *  <div class="info">Image:02</div></li>
 *  <li><div class="thumb"><img src="images2/03_thumb.jpg" alt="" width="150" height="150" /></div>
 *  <div class="info">Image:03</div></li>
 *  <li><div class="thumb"><img src="images2/04_thumb.jpg" alt="" width="150" height="150" /></div>
 *  <div class="info">Image:04</div></li>
 *  <li><div class="thumb"><img src="images2/05_thumb.jpg" alt="" width="150" height="150" /></div>
 *  <div class="info">Image:05</div></li>
 * </ul>
 * 
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * 
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 */
 
(function($,$$) { 
		  
 this.mooZoomGallery = new Class({
	
	Implements: [Options,Events],
	
	options: {
		infoClass:".info",//情報のクラス
		thumbClass:".thumb",//サムネイル画像の親クラス
		thubKey:"_thumb",//サムネイル判別キー
		thumbWidth:150,//サムネイル画像の初期横幅
		thumbHeight:150,//サムネイル画像の初期高さ
		thumbDration:700,//サムネイルの遅延
		infoDration:800,//情報の遅延
		winDration:500,//スクローラーの遅延
		moveDration:500,//移動の遅延
		tumbTransition:Fx.Transitions.Expo.easeOut,//サムネイルのトランジション
		infoTransition:Fx.Transitions.Expo.easeOut,//情報のトランジション
		winTransition:Fx.Transitions.Cubic.easeInOut,//スクローラーのトランジション
		moveTransition:Fx.Transitions.linear,//移動のトランジション
		offset:10, //窓上部からの位置
		onStart:$empty,
		onComplete:$empty,
		onCloseStart:$empty,
		onCloseComplete:$empty
	},
	
	initialize: function(element, options) {
		this.setOptions(options);
		this.container = $(element);//ul#gallery
		
		if(!this.container) return;
		
		this.lists = $(element).getChildren();//li要素
		
		this.morph = [];//Fx.Morph for thumbnail
		this.move = [];//Fx.Morph for list
		//Class Fx.Scroll
		this.Scroller = new Fx.Scroll(window, {dration:this.options.winDration, transition:this.options.winTransition});
		
		this.actPos = null;//アクティブになった要素の初期位置
		this.contSize = this.container.getStyle("height");//ul#galleryの初期サイズ

		var self = this;
		
		$each(this.lists,function(el,index){
			var info = el.getElement(self.options.infoClass);
			var image = el.getElement(self.options.thumbClass).getFirst("img");//サムネイル画像取得
			
			el.store("index",index);//インデックス番号を保存
			
			//div.thumb
			self.morph[index]= new Fx.Morph(image,{duration: self.options.thumbDration, transition: self.options.tumbTransition,link:"cancel"});
			
			//div.info
			info.setStyle("display","none");
			info.fade("hide");
			
			//list
			self.move[index] = new Fx.Morph(el,{duration: self.options.moveDration, transition: self.options.moveTransition, link:"cancel"});
			
			el.addEvent("click",function(e){
				e.stop();
				if(image.width == self.options.thumbWidth && !self.active){
					self.active = index;
					self.open(el, image, self);
				}else if(self.active == index && image.width > self.options.thumbWidth){
					self.close(el, image, self);
				}
				return false;
			});
		});
	},
	
	/**
	 * 開く
	 * @param {Object} el
	 * @param {Object} image
	 */
	open:function(el, image, self){
		
		var info = el.getElement(self.options.infoClass);
		var num = el.retrieve("index");
		var src = image.src.replace("_thumb","");//拡大画像のsrc
		this.actPos = image.getPosition(this.container);
		var w2 = 0;
		
		this.fireEvent("onStart",[el,num]);
		
		self.ListsFadeOut(num);//他の画像を隠す
		
		this.morph[num].start({'opacity':0})
		.chain(function(){
						
			new Asset.image(src,{
				
				onload: function(e){
					
					//拡大サイズの保存
					image.store("width", e.width );
					image.store("height", e.height);
					
					//open
					self.morph[num].start({
						width: e.width,
						height: e.height
					});
					
					w2 = ($(self.container).getSize().x/2) - (e.width/2);//要素の中心と親要素の始点の差分
					
					el.store("margin",el.getStyle("margin"));
					el.store("padding",el.getStyle("padding"));
					el.setStyles({ "margin":0, "padding":0});
					
					//move
					self.move[num].start( {"position":"absolute",
					"left":[self.actPos.x, w2] ,
					"top":[(image.getPosition(this.container).y/3),0]});
					
					info.setStyle("display","block");
					
					self.container.tween("height",e.height+info.getSize().y);//高さ変更
					
					image.src = src;
					
					if(Browser.Engine.trident4) image.getParent().setStyle("width",e.width);
				}
			});
		})
		.chain(function(){
			image.width = image.retrieve("width");
			image.height = image.retrieve("height");
			self.morph[num].start({'opacity':1});
			info.fade("show");
			self.Scroller.start(0, (self.container.getTop()-self.options.offset));//スクロール
			self.fireEvent("onComplete",[el,num]);
		});
	},
	/**
	 * クリックされた要素以外を非表示にする
	 * @param {int} num アクティブな要素のインデックス番号
	 */
	ListsFadeOut:function(num){
		$each(this.lists,function(el,index){
			if(index != num){
				el.removeEvent("click");
				el.fade("out",{link:"cancel"});
			}
		});
	},
	/**
	 * クリックされた要素以外を非表示にする
	 * @param {int} num アクティブな要素のインデックス番号
	 */
	ListsFadeIn:function(num){
		$each(this.lists,function(el,index){
			if(index != num)
				el.fade("in",{link:"cancel"});
		});
	},
	/**
	 * 閉じる
	 * @param {Object} el
	 * @param {Object} image
	 */
	close:function(el, image, self){
		
		var info = el.getElement(self.options.infoClass);
		var num = el.retrieve("index");

		this.fireEvent("onCloseStart",[el,num]);
		info.fade("hide");//infoを隠す
		
		this.morph[num].start({'opacity':0})
		.chain(function(){
						
			info.setStyle("display","none");
			
			//close
			self.morph[num].start({
				width: self.options.thumbWidth,
				height: self.options.thumbHeight
			});
			
			if(Browser.Engine.trident4) image.getParent().setStyle("width",self.options.thumbWidth);
			
			//move
			self.move[num].start( {
			"left":[this.element.getPosition(self.container).x, self.actPos.x],
			"top":[(image.getPosition(this.container).y/3), self.actPos.y]});
			
			image.src = self._FilePass(image.src);
		})
		.chain(function(){
			self.container.tween("height",self.contSize);//高さ変更
			el.setStyles({ "margin":el.retrieve("margin"),"padding":el.retrieve("padding"),"position":"static"});
			image.width = self.options.thumbWidth;
			image.height = self.options.thumbHeight;
			self.morph[num].start({'opacity':1});
			self.ListsFadeIn();
			self.active = null;
			self.fireEvent("onCloseComplete",[el,num]);
		});
	},
	onCloseStart:function(){
		this.options.onCloseStart();
	},
	onCloseComplete:function(){
		this.options.onCloseComplete();
	},
	_FilePass:function(src){
		var Reg = src.match(/(.+?)(.\w{3})$/i);
		return Reg[1]+this.options.thubKey+Reg[2];
	}
	
});
 
})(document.id,document.search);