/**
 * mooContreGallery
 * @author Tenderfeel
 * @ver 1.1
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need: MooTools core 1.2 upper
 * @More: Assets, Slide, Scroll
 * 
 * 
 * このプラグインは、contreforme sàrlのProjectsページで使われている
 * 画像拡大、スクロール、インフォメーション表示などの演出効果を実装するものです。
 * 
 * 
 * ---::Notice::------------------------------------------------
 * 
 *
 * This class original source created from contreforme sàrl.
 *
 * 
 * @Website URI: http://www.contreforme.ch/
 * 
 *
 * ---MIT License--------------------------------------------
 * 
 * Copyright (c) 2009 Tenderfeel all rights reserved.
 * 
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 */
 
(function($,$$) { 
		  
this.mooContreGallery = new Class({
	
	Implements: [Options,Events],
	
	options: {
		infoClass:".info",//スライドさせる要素のクラス
		thumbClass:".thumb",//サムネイル画像の親クラス
		thubKey:"_thumb",//サムネイル判別キー
		thumbDration:700,//サムネイルの遅延
		infoDration:800,//情報の遅延
		winDration:500,//スクローラーの遅延
		tumbTransition:Fx.Transitions.Back.easeOut,//サムネイルのトランジション
		infoTransition:Fx.Transitions.Expo.easeOut,//情報のトランジション
		winTransition:Fx.Transitions.Cubic.easeInOut,//スクローラーのトランジション
		offset:10, //窓上部からの位置
		reducing:false, //開いている画像をクリックした際に縮小するかどうか
		onComplete:$empty,
		onStart:$empty,
		onCloseStart:$empty,
		onCloseComplete:$empty
	},
	
	initialize: function(element, options) {
		this.setOptions(options);
		if(!$(element)) return;
		
		this.lists = $(element).getChildren();//リスト要素取得
		
		this.morph = [];//Fx.Morph
		this.slide = [];//Fx.Slide
		
		this.size = [];//width and height
		
		this.active = null;//アクティブな要素
		
		//Class Fx.Scroll
		this.Scroller = new Fx.Scroll(window, {dration:this.options.winDration, transition:this.options.winTransition});

		
		var self = this;
		
		$each(this.lists,function(el,index){	
			var image = el.getElement(self.options.thumbClass).getElement("img");//サムネイル画像取得
			
			self.size[index] = image.getSize();//元サイズを格納
			
			el.store("index",index);//インデックス番号を保存
			
			//サムネイルにFx.Morph
			self.morph[index]= new Fx.Morph(image,{duration: self.options.thumbDration, transition: self.options.tumbTransition,link:"chain"});
			
			//スライドさせる要素にClass Fx.Slide
			self.slide[index] = new Fx.Slide(el.getElement(self.options.infoClass),{
				duration: self.options.infoDration,
				transition: self.options.infoTransition,link:"chain"
			}).hide();//非表示にしておく
			
			
			//クリックイベント登録
			el.addEvent("click",function(e){
				e.stop();
				if(image.width == self.size[index].x){
					self.open(el,image,self);
				}else if(self.options.reducing === true){
					self.active = null;
					self.close(el,index,self);
				}
				
			});
		});


	},
	open:function(el,image,self){
		var num = el.retrieve("index");
		var src = image.src.replace("_thumb","");//拡大画像のsrc
		
		self.fireEvent("onStart",[el,num]);
		
		this.morph[num].start({'opacity':0.3})
		.chain(function(){
			//フル画像のプリロード Class Assets
			new Asset.image(src,{
				
				onload: function(e){
					
					//拡大サイズの保存
					image.store("width", e.width );
					image.store("height", e.height);
					
					//サムネイルモーフィング(open)
					self.morph[num].start({
						width: e.width,
						height: e.height
					});

					self.slide[num].slideIn();//スライドイン
				}
			});
		})
		.chain(function(){
			image.width = image.retrieve("width");
			image.height = image.retrieve("height");
			image.src = src;
			self.morph[num].start({'opacity':1});
			if(self.options.reducing !== true) el.setStyle("cursor","default");
			
			self.fireEvent("onComplete",[el,num]);
		});
			
		if(this.active != null && this.active != num){
			this.close(el, this.active, self);
		}else{
			this.Scroller.start(0, (el.getTop()-this.options.offset));//スクロール
		}
		
		this.active = num;//アクティブな要素のインデックスを保存

	},
	close:function(el, act, self){
		
		this.fireEvent("onCloseStart",[this.lists[act],act]);
		this.morph[act].start({'opacity':0.3})
		.chain(function(){
			this.start({
				width:self.size[act].x,
				height:self.size[act].y
			});
			self.slide[act].slideOut();//スライドアウト
		})
		.chain(function(){
			this.element.width = self.size[act].x;
			this.element.height = self.size[act].y;
			this.element.src = self._FilePass(this.element.src);
			self.morph[act].start({'opacity':1});
			if(self.options.reducing !== true) self.lists[act].setStyle("cursor","pointer");
			self.Scroller.start(0, (el.getTop()-self.options.offset));//スクロール
			self.fireEvent("onCloseComplete",[self.lists[act],act]);
		});
	},
	onCloseStart:function(){
		this.options.onCloseStart();
	},
	onCloseComplete:function(){
		this.options.onCloseComplete();
	},
	_FilePass:function(src){
		var Reg = src.match(/(.+?)(.\w{3})$/i);
		return Reg[1]+this.options.thubKey+Reg[2];
	}
});
})(document.id,document.search);