/**
 * Zawazawa
 * @author Tenderfeel
 * @ver 1.2
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need:mootools 1.2
 * 
 * カイジの「ざわ…」をページ上に表示するプラグイン
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 */
var Zawazawa = new Class({
	Implements: [Options],
	options: {
		padding:60,
		zIndex:999,
		minFont:10,
		maxFont:30,
		follow:true
	},
	initialize: function(element,options) {
		this.setOptions(options);
		console.log(element);
		if(element) this.element = element;
		else this.element = $$("body");
		this.max = this.options.max;
		this.zawa = null;
		this.wx = $(window.document).getSize().x;
		this.wy = this.t = $(window.document).getSize().y;
		this.pd = this.tpd = this.options.padding;
		this.ssize =null;
		if(this.options.follow == true){
			window.addEvent("scroll",function(){
				this.follow();
			}.bind(this));
		}
	},
	follow:function(){
		this.ssize = window.getScroll();
		this.tpd = (this.ssize.y + this.pd);
		this.t = (this.wy + this.ssize.y);
	},
	start:function(){
		this.zawa = this.addStr.periodical(1000,this);
		if(this.options.follow == false)
			this.element.setStyle("overflow","hidden");
	},
	stop:function(){
		$clear(this.zawa);
		if(this.options.follow == false)
			this.element.setStyle("overflow","auto");
	},
	createStr:function(f){
		var str = new Element("span",{
			text:"ざわ…",
			"class":"zawa",
			styles:{
				"top":this.top,
				"left":this.left,
				"font-size":f,
				"z-index":this.options.zIndex,
				"position":"absolute"
			}
		});
		return str;
	},
	addStr:function(){
		this.top = $random(this.tpd,(this.t - this.pd*2))
		this.left = $random(this.pd,(this.wx - this.pd*2));
		var span = this.createStr($random(this.options.minFont,this.options.maxFont));
		var fx = new Fx.Tween(span,{property:'opacity', duration: 1500, transition:"linear",
			onComplete:function(){span.destroy();}});
		this.element.grab(span);
		(function(){fx.start(0)}).delay(3000);
	}
});