/**
 * jAnalogIE
 * @author Tenderfeel
 * @ver 1.0
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need:jQuery ver1.2.6 upper
 * 
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 */

(function($) {
	$.fn.jAnalogIE = function(options){
		var options = {
			site: "STOP",
			title: "",
			text: "アナログ",
			message:"今すぐバージョンアップ！",
			top : 20,
			right : 20,
			delay:300
		};
		return this.each(function(){
			if ( $.browser.msie && $.browser.version !="7.0" && navigator.appVersion.indexOf("MSIE 8.")==-1) {
				var icon = $("<div id=\"analog\"></div>");
				var position = $("html").scrollTop();
				icon.css({
					"position":"absolute",
					"top": (position + options.top) + "px",
					"right":options.right + "px"
				});
				
				switch(options.site){
					case "STOP":
						title = (options.title !="") ? options.title : "stop IE6 campain";
						icon.html("<a href=\"http://www.stopie6.org/\" title=\""+title+"\" target=\"_blank\">"+options.text+"</a>");
					break;
					case "END":
						title = (options.title !="") ? options.title :"end 6";
						icon.html("<a href=\"http://www.end6.org/\" title=\""+title+"\" target=\"_blank\">"+options.text+"</a>");
					break;
					case "FF":
						title = (options.title !="") ? options.title : "Download Firefox3";
						icon.html("<a href=\"http://mozilla.jp/firefox/\" title=\""+title+"\" target=\"_blank\">"+options.text+"</a>");
					break;
					default:
						icon.html("<a href=\""+options.site+"\" title=\""+options.title+"\" target=\"_blank\">"+options.text+"</a>");
				}
				
				$(this).prepend(icon);
				
				$(window).scroll(function () { 
			     	var size = $("html").scrollTop() + options.top;
					icon.hide();
					icon.css({"top":size,"right":options.right + "px"});
					icon.fadeIn(options.delay);
			    });
				
				 icon.hover(
			      function () {
			        $(this).find("a").html(options.message);
			      }, 
			      function () {
			        $(this).find("a").html(options.text);
			      }
			    );

			}
		});
	};
})(jQuery);