/**
 * KitchenTimer
 * @author Tenderfeel
 * @ver 1.0
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need:mootools 1.2
 * 
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 * 
 * [options]
 * 
 * limit : 制限時間(秒)
 * mode  : 動作モード（up:カウントアップ　down:カウントダウン）
 * onComplete :　カウントダウン終了時のアクション
 * 
 */

var KitchenTimer = new Class({
	
	Implements:[Options,Events],
	
	options:{
		limit:60,
		mode:'down',
		onComplete:$empty
	},
	
	initialize:function(element,options){
		this.setOptions(options);
		this.element = element;
		this.limit = (this.options.limit * 1000);
		this.mode = this.options.mode;
		
		if(this.mode == "down")
			this.time = this.limit;
		else if(this.mode =="up")
			this.time =0;
			
		this.cd = null;
		this.M = 0;
		this.S = 0;
		
		this.setter(this.time);
		this.element.set("text",this.M+":"+this.S);
	},
	
	setlimit:function(t){
		this.limit = (t*1000);	
	},
	
	setmode:function(m){
		this.mode =m;
	},
	
	start:function(){
		if(this.cd != null) this.pause();
		this.cd = this.timer.periodical(1000,this);
	},
	
	pause:function(){
		$clear(this.cd);
	},
	
	reset:function(){
		$clear(this.cd);
		
		switch(this.mode){
			case "down":
				this.time = this.limit;
			break;
			case "up":
				this.time = 0;
			break;
		}
		
		this.setter(this.time);
		this.element.set("text",this.M+":"+this.S);
	},
	
	setter:function(T){
		M = Math.floor(T/(60*1000));
		T = T-(M*60*1000);
		S = Math.floor(T/1000);
		
		if(S < 10) S = "0"+S;
		if(M < 10) M = "0"+M;
		
		this.S = S;
		this.M = M;
	},
	
	timer:function(){
		
		switch(this.mode){
			case "down":
				this.time = this.time - 1000;
			break;
			case "up":
				this.time = this.time + 1000;
			break;
		}
		
		T = this.time;
		
		this.setter(T);
		
		this.element.set("text",this.M+":"+this.S);
		
		if(this.time==0&&this.mode =="down"){
			$clear(this.cd);
			this.fireEvent('complete');
		}
		if(this.time==3600000 && this.mode =="up"){
			this.reset();
		}
	}
});