/**
 * mooFollow
 * @author Tenderfeel
 * @ver 1.5
 * @HOME http://tenderfeel.xsrv.jp/
 * 
 * @Need:mootools 1.2 upper
 * 
 * ---MIT License--------------------------------------------
 * Copyright (c) 2008 Tenderfeel all rights reserved.
 * 以下に定める条件に従い、本ソフトウェアおよび関連文書の
 * ファイル（以下「ソフトウェア」）の複製を取得するすべての
 * 人に対し、ソフトウェアを無制限に扱うことを無償で許可します。
 * これには、ソフトウェアの複製を使用、複写、変更、結合、
 * 掲載、頒布、サブライセンス、および/または販売する権利、
 * およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 * 
 * 上記の著作権表示および本許諾表示を、
 * ソフトウェアのすべての複製または重要な部分に記載するものとします。
 * 
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、
 * 契約行為、不法行為、またはそれ以外であろうと、
 * ソフトウェアに起因または関連し、あるいはソフトウェアの使用
 * またはその他の扱いによって生じる一切の請求、損害、
 * その他の義務について何らの責任も負わないものとします。 
 * ----------------------------------------------------------
 */

var mooFollow = new Class({
	
	Implements: [Options,Events],

	options: {
		transition:"sine:out",
		duration:"long",
		link:"cancel",
		top:null,
		watermark:false,
		watermarkHtml:"▲ページトップに戻る",
		watermarkHref:"#header",
		SmoothScroll:false,
		onStart:$empty,
		onComplete:$empty
	},
	initialize: function(element,options) {
		this.setOptions(options);
		if(element==null) this.element = $("follower");
		else this.element = element;
		this.tran = this.options.transition;
		this.dur = this.options.duration;
		this.link = this.options.link;
		this.position = null;
		this.parent = this.element.getParent();
		this.parentPosition = null;
		this.scrollsize = null;
		this.fx = null;
		this.setElPosition();
		this.setElStyles();
		this.makeFx();
		if(this.options.watermark == true) this.watermark();
		if(this.options.top === null) this.top = this.position.y;
		else this.top = this.options.top;
		
		window.addEvents({
			"scroll":function(){this.follow();}.bind(this),
			"domready":function(){this.follow();}.bind(this)
			});
		
		return true;
	},
	setElPosition: function() {
		this.parent.setStyles({"position":"relative"});
		this.position = this.element.getPosition(this.parent);
		this.parentPosition = this.parent.getPosition();
	},
	makeFx:function(){
		this.fx = new Fx.Morph(this.element,{duration:this.dur,transition:this.tran,link:this.link,
		onStart:function(){
			this.fireEvent('start');
			if(this.options.watermark == true){
				this.watermark.fade("hide");
				this.addWatermark();
			}
		}.bind(this),
		onComplete:function(){
			this.fireEvent('complete');
			if(this.options.watermark == true) this.watermark.fade("in",{duration:500});
		}.bind(this)});
	},
	setScrollsize:function(){
		this.scrollsize = window.getScroll();
	},
	setElStyles:function(){
		this.element.setStyles({"position":"absolute","top":this.position.y,"left":this.position.x,"margin":0});	
	},
	follow:function(){
		this.setScrollsize();
		
		if (this.position.y >= this.scrollsize.y||this.parentPosition.y >= this.scrollsize.y) {
			this.fx.start({top: this.position.y+"px"});
		} else {
			if(this.parent.getSize().y < (this.scrollsize.y + this.element.getSize().y + this.top)){
				this.fx.start({top:(this.parent.getSize().y-this.element.getSize().y )+"px"});
			}else if((this.scrollsize.y - this.parentPosition.y) + this.top < this.position.y){
				return;
			}else if(this.scrollsize.y >= this.position.y){
				this.fx.start({top: ((this.scrollsize.y - this.parentPosition.y) + this.top)+"px"});
			}
		}
		
	},
	watermark:function(){
		this.watermark = new Element("a",{
			"class":"gotoTop",
			"id":this.element.id+"-gotoTop",
			"href":this.options.watermarkHref,
			html:this.options.watermarkHtml,
			styles:{
				"opacity":0,
				"display":"block"
			}
		});
	},
	addWatermark:function(){
		if($$("#"+this.element.id+" a.gotoTop")[0]==null) {
			this.watermark.inject(this.element);
			if(this.options.SmoothScroll&&this.options.watermark) new Fx.SmoothScroll({duration:500,links:"#"+this.element.id+"-gotoTop"});
		}
		if (this.position.y >= this.scrollsize.y)
			this.watermark.dispose();
	}
});