/**
 * Writing Speed Counter 
 * @version 1.0
 * @author Tenderfeel
 * @use mootools ver1.2
 * 
 * (c)Copyright 2008 Tenderfeel All Rights Reserved.
 * 
 * MIT Style License.
 * 
 * 入力時間と文字数をリアルタイムで計測
 * 最初の一文字を入力した時点から、確定エンターキーを押すまでの時間を計測します
 * Timeは1秒程度の誤差が生じるため、Resultはタイムスタンプを元に計算しています。
 * 
 */

window.addEvent('domready', function(){

//要素の定義
var textarea  = $('myTextarea'); //テキストエリア
var startDiv  = $('start');      //スタート時間(Start)
var stopDiv   = $("stop");       //ストップ時間(Stop)
var resultDiv = $("result");     //結果(Result)
var nowDiv    = $('now');        //経過時間(Time)
var exportDiv = $("log");        //入力ログ表示エリア
var totalDiv  = $("lng");        //文字数カウント(String)
var delButton = $("del");        //ログの削除ボタン
var checkbox  = $("clear");      //Clearチェックボックス
var focusbox  = $("focus");      //Focusチェックボックス
var aveButton =$("average");     //平均出力ボタン

var countup; //経過時間カウンター
var f=0; //削除ボタンのフラグ

delButton.fade("hide");
textarea.focus();//フォーカスさせる
Event.Keys.enter = 13; //EnterKey name setting "enter"

var firstflag = 0; //FirstKeyDown flag
var enterflag = 0; //SubmitEnterKey flag

//div#result Morph
var highlight = new Fx.Morph(resultDiv, {
        duration: 1500,
        link: 'cancel',
        transition: 'quad:out'
    });
	
//countup timer hash
var Times = new Hash ({
	'start':0,
	'sec':0,
	'min':0,
	'hou':0
});

var StmpResults = new Array();
var LngResults = new Array();

if(StmpResults.length==0||LngResults.length==0)
	aveButton.setStyle("display","none");
		
	textarea.addEvents({
	
       	keydown:function(event){ //keydown event
			
			if(firstflag==0){ //First String
			
				//前のカウント結果消去
				stopDiv.set("text","Stop:"); 
				resultDiv.set("text","Result:");
				nowDiv.set("text","Time:");
				//Hash clear
				Times.each(function(value, key){
					Times.set(key,0);
				});
				
				//開始タイムスタンプ
				Times.set('start', $time());
				var startTime = new Date();
				
				startDiv.set('text', "Start: " + startTime.toLocaleTimeString());
				firstflag=1;
				//カウント開始（periodical=停止まで1秒毎に繰り返す）
				countup = addCount.periodical(1000, Times);
			}
			//EnterKey フラグのカウントアップ
			if (event.key == "enter") enterflag++;
			
		},
		keyup: function(event) {
			
		    //文字数カウンタ
			totalDiv.set("text",this.value.length);
			
			//EnterKeyフラグが1以上なら結果表示
			if (event.key == "enter" && enterflag >=1){
				textarea.fireEvent('burn');
				enterflag =0;
				$clear(countup);//periodical stop
			}
		},
		burn: function() {
		
            firstflag = 0;
			
			Times.set('stop',$time()); //停止時間タイムスタンプ
			var Stoptime =new Date();
			
			//Result
			T = Times.stop - Times.start;
			var speed = timestamp_dec(T);
			
			var lng = totalDiv.get('text');
			
			//ClearがOFFならログ出力
			if(checkbox.checked != true){
			 	exportLog( textarea.value, speed.h+":"+speed.m+":"+speed.s,lng);
			}
			
			//停止時間のセット
			stopDiv.set('text', "Stop: " + Stoptime.toLocaleTimeString());
			
			//結果のセット
			resultDiv.set('text', "Result: "+H+":"+M+":"+S);
			
			textarea.value = '';
			
			ResultSave(T,lng);//結果保存
			
            //ハイライト
            highlight.start({
                backgroundColor: ['#0D558A', '#1F2225']
            });
        }
		
    });
	
	//結果を配列に保存
	function ResultSave(stmp,lng){
		StmpResults.push(stmp);
		LngResults.push(lng);
		
		if(StmpResults.length>=2||LngResults.length>=2)
			aveButton.setStyle("display","inline");
	}
	
	//ログ出力
	function exportLog(txt,time,lng){
		var p = new Element("p");
		var about = "[ Result: "+time+" String:"+lng+"]";
		
		if (focusbox.checked == true) {
			var InputTxt = new Element("input", {
				"type": "text",
				"size": "50",
				"value": txt,
				"class": "log",
				"onfocus": "this.select()"
			})
			p.set("html", about);
			InputTxt.inject(p, "top");
		}else{
			p.set("html", txt + about);
		}
		exportDiv.grab(p,"top");
		if(f==0){
			 delButton.fade('in');
			 f=1;
		}
	}
	//削除ボタンアクション
	delButton.addEvent("click",function(){
			exportDiv.empty();
			delButton.fade("hide");
			f=0;
	});
	
	//経過時間カウンター
	var addCount = function(){ 
		this.sec++;
		if(this.sec==60){
			this.sec = 0;
			this.min++;
		}
		if(this.min==60){
			this.min=0;
			this.hou++;
		}
		nowDiv.set("text","Time:"+this.hou+":"+this.min+":"+this.sec);
	};
	
	//Average Button Action
	aveButton.addEvent("click",function(){
		if($("writing-avarage")) $("writing-avarage").destroy();
			SpeedAverage();
	})
	
	
	//平均の計算と表示
	function SpeedAverage(){	
		var stmps = 0;
		var lngs = 0;
		StmpResults.each(function(item, index){
			stmps = parseInt(stmps) + item;
		});
		LngResults.each(function(item, index){
		  lngs = parseInt(lngs) + parseInt(item);
		});
		stmps = stmps/StmpResults.length;
		lngs = lngs/LngResults.length;
		
		var ave = timestamp_dec(stmps.round());
		var averageDiv = new Element("p",{"id":"writing-avarage"});
		var aTime = new Element("span",{"class":"time-avarage"});
		var aLng = new Element("span",{"class":"string-avarage"});
		aTime.set("html", "Time Average: "+ave.h+":"+ave.m+":"+ave.s);
		aLng.set("html", "String Average: "+lngs.round(1));
		averageDiv.grab(aTime);
		averageDiv.grab(aLng);
		
		var highlight2 = new Fx.Morph(averageDiv, {
	        duration: 1000,
	        transition: 'quad:out'
	    }).start({
                backgroundColor: ['#008080', '#1F2225'],
				color:['#008080', '#00d9d9']
            });
		$("status").grab(averageDiv);
	}
	
	//Helps
	var Tips1 = new Tips(checkbox);
	checkbox.store('tip:title', 'Clear Mode');
	checkbox.store('tip:text', 'チェックするとログを残しません');
	
	var Tips2 = new Tips(focusbox);
	focusbox.store('tip:title', 'Focus Mode');
	focusbox.store('tip:text', 'チェックすると表示されるログがテキストボックスに入るのでコピペがしやすくなります。');
	
	var Tips3 = new Tips(delButton);
	delButton.store('tip:title', 'Delete Log');
	delButton.store('tip:text', 'ログを全て削除します');
	
	var Tips4 = new Tips(aveButton);
	aveButton.store('tip:title', 'Display Average');
	aveButton.store('tip:text', '現在までの平均を出力します');
});

/**
 * タイムスタンプの変換
 * Original:http://www.scollabo.com/banban/java/jvsample_014.htm
 */
function timestamp_dec(T){
	H = Math.floor(T/(60*60*1000));
	T = T-(H*60*60*1000);
	M = Math.floor(T/(60*1000));
	T = T-(M*60*1000);
	S = Math.floor(T/1000);
	return {"h":H,"m":M,"s":S};
}
