/*
Script: slideBox.js
	slideBox - slideBox version 1.0

License:
	MIT-style license.

Copyright:
	Copyright 2008
	Riaan Los
	http://www.riaanlos.nl

Based on MooTools v1.2 Core
	[The MooTools production team](http://mootools.net/developers/).


Usage:
	window.addEvent('domready', function() {
		var example1 = new slideBox('example1');
		var example2 = new slideBox('example2',{
			speed:10,
			removeArrows:false,
			transition:Fx.Transitions.Bounce.easeOut,
			fadeArrows:true,
			startOpacity:0.4
		});
	});

Keep smiling ;)
*/

var slideBox = new Class({

	Implements: [Events, Options],

options: {
	className:'slide',					// className (XHTML + CSS)
	prevArrow:'-previous',					// previous arrow className suffix
	nextArrow:'-next',						// next arrow className suffix
	removeArrows:true,						// remove arrows on top/bottom
	fadeArrows:false,						// add fade effect to arrows
	startOpacity:0.5,						// start opacity for fade effect on arrows
	endOpacity:1,							// end opacity for fade effect on arrows
	mouseoverBox:true,						// add/remove mouseenter class on UL LI elements inside slider
	startClass:'normal',					// className at mouseout
	endClass:'over',						// className at mouseenter
	speed:5,								//	scroll speed
	transition:Fx.Transitions.Quart.easeOut // scrolling transition
},

	initialize: function(element,options){
		element = $(element);
		this.setOptions(options);		
		this.active = false;

		this.up = element.getElements('div[class=' + this.options.className + '-previous]');
		this.up = this.up[0].getElements('a');
		this.up = this.up[0];
		
		this.down = element.getElements('div[class=' + this.options.className + '-next]');
		this.down = this.down[0].getElements('a');
		this.down = this.down[0];
		
		this.wrapper = element.getElements('div[class=' + this.options.className + '-wrapper]');
		this.wrapperH = this.wrapper[0].getStyle('height').toInt();
		
		this.slider = this.wrapper[0].getElements('div[class=' + this.options.className + '-slider]');
		this.slider = this.slider[0];
		
		
		if(this.options.removeArrows) this.removeArrows();
		if(this.options.fadeArrows) this.fadeArrows();
		if(this.options.mouseoverBox) this.mouseoverBox();
		
		this.clickEvent(element);
		
		this.mouseEvent(element);
	},
	
	removeArrows: function() {
		this.start = this.slider.getStyle('top').toInt();			
		if(this.start==0) this.up.getParent().setStyle('display','none');
	},
	
	fadeArrows: function(){
		this.up.setStyle('opacity',this.options.startOpacity);
		this.down.setStyle('opacity',this.options.startOpacity);
		
		this.up.addEvent('mouseenter', this.up.fade.bind(this.up,[this.options.endOpacity]));
		this.down.addEvent('mouseenter', this.down.fade.bind(this.down,[this.options.endOpacity]));
		
		this.up.addEvent('mouseleave', this.up.fade.bind(this.up,[this.options.startOpacity]));
		this.down.addEvent('mouseleave', this.down.fade.bind(this.down,[this.options.startOpacity]));
	},
	
	mouseoverBox: function(){
		$$('.' + this.options.className + '-slider UL LI').each(function(element,index){
			element.addClass(this.options.startClass);
			element.addEvent('mouseenter',function(){
				element.addClass(this.options.endClass);
				element.removeClass(this.options.startClass);
			}.bind(this));
			element.addEvent('mouseleave',function(){
				element.addClass(this.options.startClass);
				element.removeClass(this.options.endClass);
			}.bind(this));
		}.bind(this));
	},
	
	setArrows: function() {
		this.current = this.slider.getStyle('top').toInt();
		this.last = 0-(((this.height/this.wrapperH)-1)*this.wrapperH);
		if(this.current==0) { 
			this.up.getParent().setStyle('display','none');
			this.down.getParent().setStyle('display','block');
		} else if(this.current > this.last) {
			this.up.getParent().setStyle('display','block');
			this.down.getParent().setStyle('display','block');
		} else {
			this.up.getParent().setStyle('display','block');
			this.down.getParent().setStyle('display','none');
		}
	},
	mouseEvent: function(element){
		
		this.height = this.slider.getSize().y;		
		this.slideeFx = new Fx.Tween(this.slider,{
			duration:(1*100),
			transition:Fx.Transitions.linear,
			wait:false,
			speed:1,
			onComplete:function(){
				this.active = false;
				if(this.options.removeArrows) this.setArrows();
			}.bind(this)
		});
		this.wrapper.addEvent('mousewheel', function(e){
				e.stop();
				if (e.wheel < 0) this.mousewDown();
				else this.mousewUp();
		}.bind(this));

	},
	clickEvent: function(element){		
		this.height = this.slider.getSize().y;		
		this.slideFx = new Fx.Tween(this.slider,{
			duration:(this.options.speed*100),
			transition:this.options.transition,
			wait:false,
			onComplete:function(){
				this.active = false;
				if(this.options.removeArrows) this.setArrows();
			}.bind(this)
		});
		
		this.up.addEvent('click',function(e){
			var e = new Event(e).stop();
			if(this.active==false) {
				this.scrollUp();
			}
		}.bind(this));
		
		this.down.addEvent('click',function(e){
			var e = new Event(e).stop();
			if(this.active==false) {
				this.scrollDown();
			}
		}.bind(this));
	},
	mousewDown: function(){		
		this.now = this.slider.getStyle('top').toInt();		
		this.last = 0-(((this.height/this.wrapperH)-1)*this.wrapperH);
		if(this.now > this.last) {
			this.active = true;
			this.slideeFx.start('top',(this.slider.getStyle('top').toInt()-100)+'px');
		}
	},
	mousewUp: function() {
		this.now = this.slider.getStyle('top').toInt();
		this.last = 0-(((this.height/this.wrapperH)-1)*this.wrapperH);		
		if(this.now < 0) {
			this.active = true;
			if(this.now==0){
				return false;
			}else if((this.now+100) > 0){
				var num = ""+this.now;
				num =num.replace("-","");
				this.slideeFx.start('top',(this.now+eval(num))+'px');
			}else{
				this.slideeFx.start('top',(this.now+100)+'px');
			}
			
		}
	},
	scrollDown: function(){		
		this.now = this.slider.getStyle('top').toInt();		
		this.last = 0-(((this.height/this.wrapperH)-1)*this.wrapperH);
		if(this.now > this.last) {
			this.active = true;
			this.slideFx.start('top',(this.slider.getStyle('top').toInt()-this.wrapperH)+'px');
		}
	},
	
	scrollUp: function() {
		this.now = this.slider.getStyle('top').toInt();
		this.last = 0-(((this.height/this.wrapperH)-1)*this.wrapperH);	
		if((this.now+this.wrapperH) > 0){
				var num = ""+this.now;
				num =num.replace("-","");
				this.slideFx.start('top',(this.now+eval(num))+'px');
		}else if(this.now < 0) {
			this.active = true;
			
			this.slideFx.start('top',(this.now+this.wrapperH)+'px');
		}
	}

});